*******************************************************************************
*                      68000/68010 Grundprogramm disass                       *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                            68000 Disassembler                               *
*******************************************************************************


                                * a0 ist GERADE Ziel-Adresse fr Text
trapdisass:                     * Disass ber Trap aufgerufen
 movem.l d0-d7/a0-a4,-(a7)      * Alle Register retten
 movea.l a0,a4                  * Ziel-Adresse
 and.b #$fe,d0                  * Auf gerade Adresse bringen
 movea.l d0,a3                  * Adresse Befehl
 bsr.s disass1
 movem.l (a7)+,d0-d7/a0-a4      * Register zurck
rts

disass:                         * a3 ist Adresse Befehl
 lea einbuf(a5),a4              * Ziel ist einbuf
disass1:                        * Einsprung, wenn anderes Ziel
 movea.l a4,a0                  * Es werden keine Register gerettet
 move (a3),d0                   * Befehl holen
 rol #5,d0                      * Bits 7-4 bestimmen Gruppe
 and #$1e,d0
 move beftab(pc,d0.w),d0
 jsr beftab(pc,d0.w)            * Gruppe aufrufen
 clr.b (a0)                     * Endekennung
rts

beftab:                         * Adresstabelle der einzelnen Gruppen
 dc.w gruppe0-beftab
 dc.w gruppe1-beftab
 dc.w gruppe2-beftab
 dc.w gruppe3-beftab
 dc.w gruppe4-beftab
 dc.w gruppe5-beftab
 dc.w gruppe6-beftab
 dc.w gruppe7-beftab
 dc.w gruppe8-beftab
 dc.w gruppe9-beftab
 dc.w nobefehl-beftab           * Kein Befehl in dieser Gruppe beim 68008/68010
 dc.w gruppe11-beftab
 dc.w gruppe12-beftab
 dc.w gruppe13-beftab
 dc.w gruppe14-beftab
 dc.w nobefehl-beftab           * Kein Befehl in dieser Gruppe beim 68008/68010

gruppe0:
 move (a3),d0                   * MOVEP
 and #$f138,d0
 cmp #$0108,d0
 bne.s gr0001
 move.l #'MOVE',(a0)+
 move.w #'P.',(a0)+
 move (a3),d0
 moveq #'W',d1                  * Wort
 btst.b #6,d0                   * Bit 6 bestimmt Gre
 beq.s *+4
 moveq #'L',d1                  * oder Langwort
 move.b d1,(a0)+
 tst.b d0                       * Bit 7 bestimmt Richtung
 bpl.s gr0000
 moveq #9,d3                    * Register in Speicher
 bsr dareg1                     * Datenregister
 move.b #',',(a0)+
 move 2(a3),d0                  * Wert
 bsr put4x                      * Wert wandeln
bra geta3                       * Adressregister
gr0000:                         * Speicher in Register
 move.b #' ',(a0)+
 move 2(a3),d0                  * Wert
 bsr put4x                      * Wert wandeln
 bsr geta3                      * Adressregister
 moveq #9,d3
bra dareg0                      * Datenregister
gr0001:                         * CMPI
 move (a3),d0
 and #$ff00,d0
 cmp #$0c00,d0
 bne.s gr0002
 lea eatab6(pc),a2              * Verbotene Adressierungsarten
 move.l #'CMPI',(a0)+
bra.s gr0007
gr0002:                         * ADDI
 lea    eatab4(pc),a2
 cmp #$0600,d0
 bne.s gr0003
 move.l #'ADDI',(a0)+
bra.s gr0007
gr0003:                         * SUBI
 cmp #$0400,d0
 bne.s gr0004
 move.l #'SUBI',(a0)+
bra.s gr0007
gr0004:                         * ANDI
 cmp #$0200,d0
 bne.s gr0005
 move.l #'ANDI',(a0)+
bra.s gr0007
gr0005:                         * EORI
 cmp #$0a00,d0
 bne.s gr0006
 move.l #'EORI',(a0)+
bra.s gr0007
gr0006:                         * ORI
 tst d0
 bne.s gr0008
 move.w #'OR',(a0)+
 move.b #'I',(a0)+
gr0007:                         * Einsprung fr addi/subi/cmpi/andi/eori/ori
 bsr getgroess                  * Gre holen
 bcs.s gr0008
 bsr checkadr                   * Adressierungsart prfen
 bcs.s gr0008
 move d0,d1                     * Gre merken
 lea 2(a3),a2
 move.b #' ',(a0)+
 bsr konstante                  * Konstante holen
 bcs.s gr0008
 adda d0,a2                     * Lnge der Konstanten
 move d1,d0                     * Gre zurck
 move (a3),d3
 move.b #',',(a0)+
 bsr getadr3                    * Adressierungsart
 bcs nobefehl
rts
gr0008:                         * ANDI
 movea.l a4,a0
 move (a3),d0
 and #$ff3f,d0
 cmp #$023c,d0
 bne.s gr0009
 move.l #'ANDI',(a0)+
bra.s gr0011
gr0009:                         * EORI
 cmp #$0a3c,d0
 bne.s gr0010
 move.l #'EORI',(a0)+
bra.s gr0011
gr0010:                         * ORI
 cmp #$003c,d0
 bne.s gr0013
 move.w #'OR',(a0)+
 move.b #'I',(a0)+
gr0011:                         * Einsprung fr andi/eori/ori to sr/ccr
 bsr getgroess                  * Gre holen
 bcs.s gr0013
 tst d0                         * Dadurch Entscheidung ob CCR oder SR
 bne.s gr0012
 move 2(a3),d0                  * to ccr
 bsr konstb1                    * Byte-Konstante holen
 bcs.s gr0013                   * Kein Byte
 move.b #',',(a0)+
 move.b #'C',(a0)+
 move.b #'C',(a0)+
 move.b #'R',(a0)+
rts
gr0012:                         * to sr
 cmp #1,d0                      * Nicht Wort, dann weiter
 bne.s gr0013
 move 2(a3),d0
 bsr konstw1                    * Wort-Konstante holen
 move.b #',',(a0)+
 move.b #'S',(a0)+
 move.b #'R',(a0)+
rts
gr0013:
 movea.l a4,a0                  * BCHG/BSET/BCLR/BTST
 move (a3),d0
 btst #8,d0
 bne.s gr0014                   * Bit 8 mu gesetzt sein
 and #$ff00,d0
 cmp #$0800,d0
 bne gr0016                     * Bit 9,10,11 nicht gesetzt, wenn Bit 8 gesetzt
gr0014:                         * bchg/bset/bclr/btst
 move (a3),d0
 and #$00c0,d0
 lsr #3,d0                      * Erkennung, welcher Befehl
 lea gr0tab0(pc,d0.w),a1
 move.l (a1)+,(a0)+
 move.l (a1),d0
 lea gr0tab0(pc,d0.l),a2        * Tabelle erlaubter Adressierungen
 moveq #0,d0                    * Normalerweise Byte
 move (a3),d1
 lsr #3,d1
 and #$7,d1
 bne.s *+4                      * Bei Datenregister als Ziel Langwort
 moveq #2,d0
 bsr putgroess                  * Gre ausgeben
 bsr checkadr                   * Adressierungsart prfen
 bcs.s gr0016
 btst.b #0,(a3)                 * Bit 0 bestimmt Art des Befehls
 bne.s gr0015
 move d0,d1                     * #konst,(ea)
 move 2(a3),d0
 bmi.s gr0016                   * Bereichsberschreitung
 moveq #8,d2                    * Von Null bis 7 oder bis 31
 lsl d1,d2                      * ( Hngt von der Gre (Byte,Long) ab )
 cmp d2,d0
 bpl.s gr0016                   * Bereich zu gro
 bsr konstb1                    * Konstante ermitteln
 bcs.s gr0016
 move d1,d0                     * Gre zurck
 bsr getsadr0                   * Adressierungsart
 bcs nobefehl
rts
gr0015:
 moveq #9,d3                    * dn,<ea>
 bsr dareg1                     * Datenregister
 bsr getadr0                    * Adressierungsart
 bcs nobefehl
rts

gr0tab0:                        * Befehl und verbotene Adressierungsarten
 dc.l 'BTST',eatab6-gr0tab0
 dc.l 'BCHG',eatab4-gr0tab0
 dc.l 'BCLR',eatab4-gr0tab0
 dc.l 'BSET',eatab4-gr0tab0

gr0016:
 movea.l a4,a0
 move.l (a3),d0                 * moves
 and.l #$ff0007ff,d0
 cmp.l #$0e000000,d0
 bne.s gr0018                   * Nicht moves
 move.l #'MOVE',(a0)+
 move.b #'S',(a0)+
 bsr getgroess                  * Gre ausgeben
 bcs.s gr0018
 move 2(a3),d0
 btst #11,d0                    * Richtung
 beq.s gr0017
 addq.l #2,a3                   * moves rx,(ea)
 moveq #12,d3                   * Ziel Registernummer
 moveq #15,d4                   * Ziel D/A-Bit
 bsr reg1                       * Register ausgeben
 subq.l #2,a3                   * a3 auf alten Wert
 bsr    check2adr               * Adressierungsarten berprfen
 bcs.s gr0018
 bsr getsadr0                   * Adressierungsart ausgeben
 bcs nobefehl
rts
gr0017:                         * moves (ea),rx
 bsr    check2adr               * Adressierungsarten prfen
 bcs.s gr0018
 bsr getsadr1                   * Adressierungsart ausgeben
 bcs nobefehl
 addq.l #2,a3
 moveq #12,d3
 moveq #15,d4
bra reg0                        * Register ausgeben
gr0018:                         * Beim 68010 keine weiteren Befehle
bra nobefehl

gruppe1:                        * MOVE.B
 move (a3),d0
 and #$f1c0,d0
 cmp #$1040,d0                  * MOVEA.B ist nicht erlaubt
 beq nobefehl
 moveq #0,d0                    * Byte
bra.s movebef

gruppe2:
 moveq #2,d0                    * MOVE.L
bra.s movebef

gruppe3:                        * MOVE.W
 moveq #1,d0

movebef:                        * Routinen fr den Move-Befehl
 move.l #'MOVE',(a0)+           * Carry bei Fehler
 move (a3),d1                   * Gre in d0 bergeben
 and #$01c0,d1                  * d0=Lnge des Befehls
 cmp #$0040,d1
 bne.s movebef0
 move.b #'A',(a0)+              * MOVEA
 bsr putgroess                  * Gre holen
 bsr getadr1                    * Adressierungsart
 bcs nobefehl
 moveq #9,d3
bra adreg0                      * Adressregister als Ziel
movebef0:                       * MOVE
 bsr putgroess                  * Gre holen
 move d0,-(a7)
 bsr getadr1                    * Adressierungsart Quelle
 bcc.s *+8
 addq.l #2,a7
bra carset
 move (a3),d2
 lea 2(a3,d0.w),a1              * Anfang Zieladresse
 move (a7)+,d0                  * Gre zurck
 move.l a3,-(a7)
 lsr #3,d2
 move d2,d1
 lsr #6,d2
 and #7,d2
 and #$38,d1
 add d1,d2
 lea einbuf+130(a5),a3          * Hilfspeicher
 move d2,(a3)                   * Opcode
 bsr    check4adr               * Prfen Zieladressierungsart
 bcs.s movebef2
 move.b #',',(a0)+
 movea.l a1,a2
 move (a3),d3
 bsr getadr3                    * Adressierungsart Ziel
 bcs.s movebef2
 movea.l (a7)+,a3
rts                             * Kein Fehler
movebef2:
 movea.l (a7)+,a3
bra nobefehl                    * Fehler

gruppe4:
 lea gr4tab0(pc),a1             * Befehle aus Tabelle
 move (a3),d0
 moveq #7-1,d1                  * Anzahl der Befehle
gr4001:
 cmp (a1)+,d0                   * Befehl vergleichen
 bne.s gr4003
gr4002:
 move.b (a1)+,(a0)+             * OK, ASCII-Zeichen bertragen
 bne.s gr4002
rts
gr4003:
 addq.l #8,a1                   * Nchster Befehl, wenn nicht gefunden
dbra d1,gr4001
 and #$fff8,d0                  * SWAP
 cmp #$4840,d0
 bne.s gr4004
 move.l #'SWAP',(a0)+
 move.w #'.W',(a0)+
 moveq #0,d3
bra dareg1                      * SWAP Datenregister

gr4tab0:                        * Tabelle der Behle
 dc.b $4a,$fc,'ILLEGAL',0
 dc.b $4e,$71,'NOP',0,0,0,0,0
 dc.b $4e,$70,'RESET',0,0,0
 dc.b $4e,$73,'RTE',0,0,0,0,0
 dc.b $4e,$77,'RTR',0,0,0,0,0
 dc.b $4e,$75,'RTS',0,0,0,0,0
 dc.b $4e,$76,'TRAPV',0,0,0


gr4004:                         * UNLK
 cmp #$4e58,d0
 bne.s gr4005
 move.l #'UNLK',(a0)+
 moveq #0,d3
bra adreg1                      * Nur Adressregister
gr4005:                         * STOP
 cmp #$4e72,d0
 bne.s gr4006
 move.l #'STOP',(a0)+
 move 2(a3),d0
bra konstw1                     * Konstante
gr4006:                         * TRAP
 and #$fff0,d0
 cmp #$4e40,d0
 bne.s gr4007
 move.l #'TRAP',(a0)+
 move (a3),d0
 and #$f,d0
bra konstb1                     * Nummer Trap
gr4007:                         * MOVE USP
 cmp #$4e60,d0
 bne.s gr4009
 move.l #'MOVE',(a0)+
 move.w #'.L',(a0)+
 btst.b #3,1(a3)
 beq.s gr4008                   * MOVE USP,An
 move.l #' USP',(a0)+
 moveq #0,d3
bra adreg0                      * Adressregister
gr4008:
 moveq #0,d3                    * MOVE An,USP
 bsr adreg1
 move.b #',',(a0)+
 move #'US',(a0)+
 move.b #'P',(a0)+
rts
gr4009:
 move (a3),d0                   * LINK
 and #$fff8,d0
 cmp #$4e50,d0
 bne.s gr4010
 move.l #'LINK',(a0)+
 move.w #'.W',(a0)+
 moveq #0,d3
 bsr adreg1                     * Adressregister
 move 2(a3),d0
bra konstw0                     * Konstante
gr4010:                         * EXT
 and #$ffb8,d0
 cmp #$4880,d0
 bne.s gr4011
 move.l #'EXT.',(a0)+
 moveq #'W',d1                  * Wort
 btst.b #6,1(a3)                * Gre ermitteln
 beq.s *+4
 moveq #'L',d1                  * oder Langwort
 move.b d1,(a0)+
 moveq #0,d3
bra dareg1                      * Nur Datenregister
gr4011:
 move (a3),d0                   * JMP
 and #$ffc0,d0
 cmp #$4ec0,d0
 bne.s gr4012
 move.l #'JMP ',(a0)+
bra.s gr4013
gr4012:
 cmp #$4e80,d0                  * JSR
 bne.s gr4014
 move.l #'JSR ',(a0)+
gr4013:                         * Einsprung jmp
 bsr    check3adr               * Adressierungsarten prfen
 bcs.s gr4014
 moveq #1,d0                    * Wort, da nur gerade Adressen als Ziel erlaubt
 bsr getadr2                    * Adressierungsart prfen
 bcs nobefehl
rts
gr4014:
 movea.l a4,a0
 move (a3),d0                   * CHK.W
 and #$f1c0,d0
 cmp #$4180,d0
 bne.s gr4016
 move.l #'CHK.',(a0)+
 move.w #'W ',(a0)+
 bsr    check1adr               * Adressierungsart prfen
 bcs.s gr4015
 moveq #1,d0                    * Wort
 bsr getadr2                    * Adressierungsart
 bcs nobefehl
 moveq #9,d3
bra dareg0                      * Datenregister
gr4015:
 movea.l a4,a0
gr4016:
 move (a3),d0                   * LEA
 and #$f1c0,d0
 cmp #$41c0,d0
 bne.s gr4018
 move.l #'LEA.',(a0)+
 move.w #'L ',(a0)+
 bsr    check3adr               * Adressierungsart prfen
 bcs.s gr4017
 moveq #0,d0                    * Byte, da alle Adressen erlaubt sind
 bsr getadr2                    * Adressierungsart
 bcs nobefehl
 moveq #9,d3
bra adreg0                      * Adressregister
gr4017:
 movea.l a4,a0
gr4018:
 move (a3),d0                   * CLR
 and #$ff00,d0
 cmp #$4200,d0
 bne.s gr4019
 move.w #'CL',(a0)+
 move.b #'R',(a0)+
 bsr gr4026
 bcc carres                     * OK
 movea.l a4,a0
 move (a3),d0
 and #$ff00,d0
gr4019:
 cmp #$4400,d0                  * NEG
 bne.s gr4020
 move.w #'NE',(a0)+
 move.b #'G',(a0)+
 bsr gr4026
 bcc carres                     * OK
 movea.l a4,a0
 move (a3),d0
 and #$ff00,d0
gr4020:
 cmp #$4000,d0                  * NEGX
 bne.s gr4021
 move.l #'NEGX',(a0)+
 bsr gr4026
 bcc carres                     * OK
 movea.l a4,a0
 move (a3),d0
 and #$ff00,d0
gr4021:
 cmp #$4600,d0                  * NOT
 bne.s gr4022
 move.w #'NO',(a0)+
 move.b #'T',(a0)+
 bsr gr4026
 bcc carres                     * OK
 movea.l a4,a0
 move (a3),d0
 and #$ff00,d0
gr4022:
 cmp #$4a00,d0                  * TST
 bne.s gr4023
 move.w #'TS',(a0)+
 move.b #'T',(a0)+
 bsr.s gr4026
 bcc carres                     * OK
 movea.l a4,a0
gr4023:
 move (a3),d0                   * NBCD
 and #$ffc0,d0
 cmp #$4800,d0
 bne.s gr4024
 move.l #'NBCD',(a0)+
 move.w #'.B',(a0)+
 moveq #0,d0                    * Nur Byte als Gre
 bsr.s gr4027
 bcc carres                     * OK
 movea.l a4,a0
 move (a3),d0
 and #$ffc0,d0
gr4024:
 cmp #$4840,d0                  * PEA
 bne.s gr4025
 move.w #'PE',(a0)+
 move.b #'A',(a0)+
 moveq #0,d0                    * Byte, da alle Adressen erlaubt sind
 bsr    check3adr
 bsr.s gr4027a
 bcc carres                     * OK
 movea.l a4,a0
 move (a3),d0
 and #$ffc0,d0
gr4025:
 cmp #$4ac0,d0                  * TAS
 bne.s gr4028
 move.l #'TAS.',(a0)+
 move.b #'B',(a0)+
 moveq #0,d0                    * Byte
 bsr.s gr4027
 bcs.s gr4028                   * Fehler
rts
gr4026:                         * Einsprung fr clr/neg/negx/not/tst
 bsr getgroess                  * Gre feststellen
 bcs carset
gr4027:                         * Einsprung fr nbcd/pea/tas
 bsr    check4adr               * Adressierungsart prfen
gr4027a:
 bcs carset                     * Fehler
 bsr getadr1                    * Adressierungsart
 bcs carset                     * Fehler
bra carres                      * OK
gr4028:
 movea.l a4,a0
 move (a3),d0                   * MOVE TO CCR
 and #$ffc0,d0
 cmp #$44c0,d0
 bne.s gr4029
 move.l #'MOVE',(a0)+
 move.w #'.W',(a0)+
 move (a3),d0
 and #$003f,d0
 cmp #%111100,d0                * move #wert,ccr ?
 bne.s *+10                     * Nein, weiter
 tst.b 2(a3)                    * Nur OK, wenn Byte-Groesse
 bne nobefehl
 bsr    check1adr               * Adressierungsart prfen
 bcs.s gr4029
 moveq #1,d0                    * Gre ist Wort; obere 8 Bits werden ignoriert
 bsr getadr1                    * Adressierungsart
 bcs nobefehl
 move.b #',',(a0)+
 move.b #'C',(a0)+
 move.b #'C',(a0)+
 move.b #'R',(a0)+
rts
gr4029:
 movea.l a4,a0                  * MOVE TO SR
 cmp #$46c0,d0
 bne.s gr4030
 move.l #'MOVE',(a0)+
 move.w #'.W',(a0)+
 bsr    check1adr               * Adressierungsart prfen
 bcs.s gr4030
 moveq #1,d0                    * Wort-Gre
 bsr getadr1                    * Adressierungsart
 bcs nobefehl
 move.b #',',(a0)+
 move.b #'S',(a0)+
 move.b #'R',(a0)+
rts
gr4030:
 movea.l a4,a0                  * MOVE FROM SR
 cmp #$40c0,d0
 bne.s gr4031
 move.l #'MOVE',(a0)+
 move.l #'.W S',(a0)+
 move.w #'R,',(a0)+
 bsr    check4adr               * Adressierungsart prfen
 bcs.s gr4031
 moveq #1,d0                    * Wort-Gre
 bsr getadr2                    * Adressierungsart
 bcs nobefehl
rts
gr4031:
 movea.l a4,a0                  * MOVEM
 move (a3),d0
 and #$fb80,d0
 cmp #$4880,d0
 bne gr4033
 move.l #'MOVE',(a0)+
 move.b #'M',(a0)+
 moveq #1,d0                    * Wort
 move (a3),d1
 btst #6,d1                     * Gre bestimmen
 beq.s *+4
 moveq #2,d0                    * oder Langwort
 bsr putgroess                  * Gre ausgeben
 btst #10,d1                    * Richtung der bertragung
 beq.s gr4032
 bsr    check7adr               * Adressierungsart prfen
 bcs gr4033
 bsr getsadr1                   * Adressierungsart
 bcs nobefehl
 moveq #0,d1                    * Normale Reihenfolge
 move.b #',',(a0)+
 bsr.s getlist
 bcs nobefehl                   * Liste holen
rts
gr4032:                         * movem reglist,(ea)
 move.b #' ',(a0)+
 move (a3),d2
 and #$38,d2
 moveq #0,d1                    * Normalfall Registerfolge
 cmp #%100000,d2
 bne.s *+4
 moveq #1,d1                    * Spezialfall
 bsr.s getlist                  * Liste holen
 bcs nobefehl
 bsr    check8adr               * Adresierungsart prfen
 bcs nobefehl
 bsr getsadr0                   * Adressierungsart
 bcs nobefehl
rts

getlist:                        * a2 Adresse Liste
 move 2(a3),d0                  * d1 = 0 Normal / d1 = 1 (an)+,reglist
 beq carset                     * Keine Adresse
 tst d1
 beq.s getli2
 move d0,d1
 moveq #16-1,d7
getli1:
 roxl #1,d1
 roxr #1,d0
dbra d7,getli1                  * Jetzt in der richtigen Reihenfolge
getli2:
 moveq #'D',d1                  * d0 ist jetzt immer richtig
 bsr.s getli3                   * Erst Datenregister
 rol #8,d0
 moveq #'A',d1
 bsr.s getli3                   * Dann Adressregiser
 subq.l #1,a0                   * '/' weg
bra carres

getli3:
 moveq #0,d7
getli4:
 btst.b d7,d0                   * Anfang suchen
 beq.s getli8
 move d7,d2
getli5:
 btst.b d7,d0                   * Ende suchen
 beq.s getli6
 addq #1,d7
 cmp #8,d7                      * Kein Ende gefunden, dann nur ein Register
bne.s getli5
getli6:
 move d7,d3
 add.b #'0'-1,d3                * In ASCII wandeln
 add.b #'0',d2
 move.b d1,(a0)+                * 'D' oder 'A'
 move.b d2,(a0)+                * Nummer Anfangsregister
 neg d2
 add d3,d2                      * Abstand feststellen
 beq.s getli7                   * Null, dann nur ein Register
 move.b #'-',(a0)               * Verbindung
 cmp #1,d2
 bne.s *+6
 move.b #'/',(a0)               * Abstand nur 1 Register
 addq.l #1,a0
 move.b d1,(a0)+                * 'D' oder 'A'
 move.b d3,(a0)+                * Nummer Endregister
getli7:
 move.b #'/',(a0)+
getli8:
 addq #1,d7
 cmp #8,d7                      * Wenn alle Register durch, dann Ende
bmi.s getli4                    * Sonst weitersuchen
rts

gr4033:
 movea.l a4,a0                  * rtd
 move (a3),d0
 cmp #$4e74,d0
 bne.s gr4034
 move.l #'RTD ',(a0)+
 move 2(a3),d0
bra konstw2                     * Wort-Konstante
gr4034:
 and #$ffc0,d0                  * move from ccr
 cmp #$42c0,d0
 bne.s gr4035
 move.l #'MOVE',(a0)+
 move.l #'.W C',(a0)+
 move.w #'CR',(a0)+
 moveq #1,d0                    * Gre ist immer Wort
 bsr    check4adr               * Adressierungsarten prfen
 bcs.s gr4035
 bsr getadr0                    * Adressierungsart holen
 bcs nobefehl
rts
gr4035:
 move (a3),d0                   * movec
 and #$fffe,d0
 cmp #$4e7a,d0
 bne nobefehl                   * Beim 68010 keine weiteren Befehle
 move.l #'MOVE',(a0)+
 move.l #'C.L ',(a0)+
 move (a3)+,d0
 lsr #1,d0                      * Richtung
 bcc.s gr4036
 moveq #12,d3                   * rx,Steuerreg
 moveq #15,d4
 bsr reg2                       * Register
 move.b #',',(a0)+
 bsr.s gr4037                   * Controlregister als Ziel
 bcs nobefehl                   * Falsches Ziel
rts
gr4036:                         * Steuerreg,rx
 bsr.s gr4037                   * Controlregister als Quelle
 bcs nobefehl                   * Falsches Register
 moveq #12,d3
 moveq #15,d4
bra reg0                        * Zielregister

gr4037:                         * a3 auf Wort
 move (a3),d0
 and #$0fff,d0                  * Bits fr Register
 lea gr4037tab(pc),a1
 moveq #4-1,d7                  * 4 Register
gr4038:
 cmp (a1)+,d0                   * Vergleich
 beq.s gr4039                   * OK, Register gefunden
 addq.l #4,a1                   * Weiter testen
dbra d7,gr4038
 subq.l #2,a3                   * Alte Adresse
bra carset                      * Fehler
gr4039:
 move.b (a1)+,(a0)+             * bertragen
 move.b (a1)+,(a0)+
 move.b (a1)+,(a0)+
bra carres                      * OK

gr4037tab:
 dc.b $00,$00,'SFC',0
 dc.b $00,$01,'DFC',0
 dc.b $08,$00,'USP',0
 dc.b $08,$01,'VBR',0

gruppe5:                        * DBCC
 move (a3),d0
 and #$f0f8,d0
 cmp #$50c8,d0
 bne.s gr5001
 move.w #'DB',(a0)+
 move (a3),d0
 lsr #7,d0
 and #$1e,d0                    * Bedingungen
 cmp.b #%0010,d0
 bne.s *+8
 move.w #'RA',(a0)+             * Dbf = Dbra
bra.s gr5000
 lea gr5tab0(pc,d0.w),a1
 move.b (a1)+,(a0)+
 move.b (a1)+,(a0)+             * Bedingungen holen, wenn nicht dbra
 bne.s gr5000
 subq.l #1,a0                   * Wenn Null, dann eins zurck
gr5000:
 btst.b #0,3(a3)                * Keine ungerade Adressdistanz
 bne.s gr5001
 moveq #0,d3
 bsr dareg1                     * Datenregister
 move.b #',',(a0)+
 move 2(a3),d0
 ext.l d0
 add.l a3,d0                    * Adresse berechnen, da relativ
 addq.l #2,d0                   * Abstand Adresse zum Anfang des Befehls
bra put8x                       * Adresse

gr5tab0:                        * Tabelle der Bedingungen
 dc.b 'T',0
 dc.b 'F',0
 dc.b 'HI'
 dc.b 'LS'
 dc.b 'CC'
 dc.b 'CS'
 dc.b 'NE'
 dc.b 'EQ'
 dc.b 'VC'
 dc.b 'VS'
 dc.b 'PL'
 dc.b 'MI'
 dc.b 'GE'
 dc.b 'LT'
 dc.b 'GT'
 dc.b 'LE'

gr5001:                         * SCC
 move (a3),d0
 and #$f0c0,d0
 cmp #$50c0,d0
 bne.s gr5003
 move.b #'S',(a0)+
 move (a3),d0
 lsr #7,d0
 and #$1e,d0                    * Bedingung
 lea gr5tab0(pc,d0.w),a1
 move.b (a1)+,(a0)+             * Bedingung holen
 move.b (a1)+,(a0)+
 bne.s gr5002
 subq.l #1,a0                   * Bei Null, eins zurck
gr5002:
 moveq #0,d0
 bsr putgroess                  * Gre ist immer Byte
 bsr    check4adr               * Adressierungsart prfen
 bcs.s gr5003
 bsr getadr1                    * Adressierungsart
 bcs nobefehl
rts
gr5003:
 movea.l a4,a0                  * ADDQ
 btst #0,(a3)
 bne.s gr5004
 move.l #'ADDQ',(a0)+
bra.s gr5005
gr5004:                         * SUBQ
 move.l #'SUBQ',(a0)+
gr5005:
 bsr getgroess                  * Gre feststellen
 bcs nobefehl
 move d0,d1
 move (a3),d0
 rol #7,d0
 and #7,d0
 bne.s *+4
 moveq #%1000,d0                * Null = Acht
 bsr konstb1                    * Konstante
 move d1,d0
 bsr    check5adr               * Adressierungsart prfen
 bcs nobefehl
 bsr getadr0                    * Adressierungsart
 bcs nobefehl
rts

gruppe6:                        * BCC/BRA/BSR
 movea.l a3,a2
 move.b #'B',(a0)+
 move (a2)+,d0
 move d0,d2
 lsr #7,d0
 and #$1e,d0
 move.b gr6tab0(pc,d0.w),(a0)+  * Bedingung
 move.b gr6tab0+1(pc,d0.w),(a0)+
 tst.b d2
 beq.s gr6001                   * bcc.w
 btst.b #0,d2                   * Keine ungerade Adressdistanz
 bne nobefehl
 moveq #0,d0
 bsr putgroess                  * bcc.b
 move.b #' ',(a0)+
 move d2,d0
 ext d0
 ext.l d0
 add.l a2,d0
bra put8x                       * Adresse
gr6001:
 move (a2),d2
 btst.b #0,d2
 bne nobefehl                   * Keine ungerade Adressdistanz
 moveq #1,d0                    * Wort
 bsr putgroess                  * bcc.w
 move.b #' ',(a0)+
 move d2,d0
 ext.l d0
 add.l a2,d0
bra put8x                       * Adresse

gr6tab0:                        * Bedingungen
 dc.b 'RA'
 dc.b 'SR'
 dc.b 'HI'
 dc.w 'LS'
 dc.b 'CC'
 dc.b 'CS'
 dc.b 'NE'
 dc.b 'EQ'
 dc.b 'VC'
 dc.b 'VS'
 dc.b 'PL'
 dc.b 'MI'
 dc.b 'GE'
 dc.b 'LT'
 dc.b 'GT'
 dc.b 'LE'

gruppe7:                        * MOVEQ
 move (a3),d0
 btst #8,d0
 bne nobefehl
 move.l #'MOVE',(a0)+
 move.l #'Q.L ',(a0)+
 and #$ff,d0                    * Nur Byte-Konstante
 bsr konstb2                    * Konstante
 moveq #9,d3
bra dareg0                      * Ziel ist Datenregister

gruppe8:
 move (a3),d0                   * SBCD
 and #$f1f0,d0
 cmp #$8100,d0
 bne.s gr8003
 move.l #'SBCD',(a0)+
gr8000:                         * Einsprung abcd
 move.w #'.B',(a0)+
gr8001:                         * Einsprung addx,subx
 move (a3),d0
 btst.b #3,d0                   * Bit 3 bestimmt Adressierungsart
 bne.s gr8002
 moveq #0,d3                    * Datenregister
 bsr dareg1
 moveq #9,d3
bra dareg0                      * Datenregister
gr8002:
 move.b #' ',(a0)+              * -(an),-(am)
 move.w #'-(',(a0)+
 bsr adreg2                     * Adressregister
 move.l #'),-(',(a0)+
 moveq #9,d3
 bsr adreg2                     * Adressregister
 move.b #')',(a0)+
rts
gr8003:
 move.l #'DIVS',(a0)+           * DIVS/DIVU
 move (a3),d0
 lsr #6,d0
 and #7,d0
 cmp.b #%111,d0
 beq.s gr8004                   * DIVS
 cmp.b #%011,d0
 bne.s gr8005
 move.b #'U',-1(a0)             * DIVU
gr8004:                         * Einsprung fr divs
 move.w #'.W',(a0)+             * Immer Wort
 bsr    check1adr               * Adressierungsart prfen
 bcs.s gr8005
 moveq #1,d0                    * Wort
 bsr getadr1                    * Adressierungsart
 bcs nobefehl
 moveq #9,d3
bra dareg0                      * Ziel ist Datenregister
gr8005:
 movea.l a4,a0
 move.w #'OR',(a0)+             * OR
 bsr getgroess
 bcs nobefehl
 btst #0,(a3)                   * or <ea>,dn
 bne.s gr8006
 bsr    check1adr               * Adressierungsart prfen
 bcs nobefehl
 bsr getadr1                    * Adressierungsart
 bcs nobefehl
 moveq #9,d3
bra dareg0                      * Ziel ist Datenregister
gr8006:                         * or dn,<ea>
 moveq #9,d3
 bsr dareg1                     * Quelle ist Datenregister
 bsr    check2adr               * Adressierungart prfen
 bcs nobefehl
 bsr getadr0                    * Adressierungsart
 bcs nobefehl
rts

gruppe9:
 move (a3),d0                   * SUBX
 and #$f130,d0
 cmp #$9100,d0
 bne.s gr9001
 move.l #'SUBX',(a0)+
 move (a3),d0
 bsr getgroess                  * Gre holen
 bcc gr8001
gr9000:                         * Einsprung addx
 movea.l a4,a0
gr9001:                         * SUBA
 move (a3),d0
 and #$f0c0,d0
 cmp #$90c0,d0
 bne.s gr9002
 move.l #'SUBA',(a0)+
 moveq #1,d0                    * Wort
 btst #0,(a3)                   * Bit 0 bestimmt Gre
 beq.s *+4
 moveq #2,d0                    * Langwort
 bsr putgroess
 bsr getadr1                    * Adressierungsart
 bcs nobefehl
 moveq #9,d3
bra adreg0                      * Ziel ist Adressregister
gr9002:
 movea.l a4,a0
gr9003:                         * SUB
 move.w #'SU',(a0)+
 move.b #'B',(a0)+
 bsr getgroess                  * Gre holem
 bcs nobefehl
 btst #0,(a3)                   * sub <ea>,dn
 bne.s gr9004
 bsr getadr1                    * Adressierungsart
 bcs nobefehl
 moveq #9,d3
bra dareg0                      * Ziel ist Datenregister
gr9004:                         * sub dn,<ea>
 moveq #9,d3
 bsr dareg1                     * Quelle ist Datenregister
 bsr    check2adr               * Adressierungsart prfen
 bcs nobefehl
 bsr getadr0                    * Adressierungsart
 bcs nobefehl
rts

gruppe11:
 move (a3),d0                   * CMPM
 and #$f138,d0
 cmp #$b108,d0
 bne.s gr11000
 move.l #'CMPM',(a0)+
 bsr getgroess                  * Gre holen
 bcs.s gr11000
 move.b #' ',(a0)+
 bsr geta4                      * (an)+
 move.b #',',(a0)+
 move.b #'(',(a0)+
 moveq #9,d3
 bsr adreg2                     * (am)+
 move.b #')',(a0)+
 move.b #'+',(a0)+
rts
gr11000:                        * EOR
 movea.l a4,a0
 btst #0,(a3)
 beq.s gr11001
 move.w #'EO',(a0)+
 move.b #'R',(a0)+
 bsr getgroess                  * Gre holen
 bcs.s gr11001
 moveq #9,d3
 bsr dareg1                     * Datenregister
 bsr    check4adr               * Adressierungsart prfen
 bcs.s gr11001
 bsr getadr0                    * Adressierungsart
 bcs nobefehl
rts
gr11001:                        * CMP
 movea.l a4,a0
 btst #0,(a3)
 bne.s gr11002
 move.w #'CM',(a0)+
 move.b #'P',(a0)+
 bsr getgr1                     * Gre holen
 bcs.s gr11002
 move (a3),d1
 and #$38,d1
 cmp #%001000,d1
 bne.s *+6                      * Kein Bytevergleich Adress- / Datenregister
 tst d0
 beq.s gr11002
 bsr putgroess                  * Gre ausgeben
 bsr getadr1                    * Adressierungsart
 bcs nobefehl
 moveq #9,d3
bra dareg0                      * Datenregister
gr11002:
 movea.l a4,a0
 move (a3),d0                   * CMPA
 move.l #'CMPA',(a0)+
 and #$01c0,d0
 cmp #%011000000,d0
 bne.s gr11003
 moveq #1,d0                    * Wort
bra.s gr11004
gr11003:
 cmp #%111000000,d0
 bne nobefehl
 moveq #2,d0                    * Langwort
gr11004:
 bsr putgroess                  * Gre ausgeben
 bsr getadr1                    * Adressierungsart
 bcs nobefehl
 moveq #9,d3
bra adreg0                      * Adressregister

gruppe12:
 move (a3),d0                   * ABCD
 and #$f1f0,d0
 cmp #$c100,d0
 bne.s gr12000
 move.l #'ABCD',(a0)+
bra gr8000                      * Auswertung wie sbcd
gr12000:                        * EXG.L
 move.l #'EXG.',(a0)+
 move #'L ',(a0)+
 move (a3),d0
 and #$f1f8,d0
 cmp #$c140,d0
 bne.s gr12001
 moveq #9,d3
 bsr dareg2                     * Datenregister
 moveq #0,d3
bra dareg0                      * Tausch mit Datenregister
gr12001:
 cmp #$c148,d0
 bne.s gr12002
 moveq #9,d3
 bsr adreg2                     * Adressregister
 moveq #0,d3
bra adreg0                      * Tausch mit Adressregister
gr12002:
 cmp #$c188,d0
 bne.s gr12003
 moveq #9,d3
 bsr dareg2                     * Datenregister
 moveq #0,d3
bra adreg0                      * Tausch mit Adressregister
gr12003:                        * AND
 movea.l a4,a0
 move (a3),d0
 move.w #'AN',(a0)+
 move.b #'D',(a0)+
 bsr getgroess                  * Gre feststellen
 bcs.s gr12005
 btst #0,(a3)
 bne.s gr12004
 bsr    check1adr               * Adressierungsart prfen
 bcs.s gr12005
 bsr getadr1                    * Adressierungsart
 bcs nobefehl
 moveq #9,d3
bra dareg0                      * Datenregister
gr12004:                        * and dn,<ea>
 moveq #9,d3
 bsr dareg1                     * Datenregister
 bsr    check2adr               * Adressierungsart prfen
 bcs.s gr12005
 bsr getadr0                    * Adressierungsart
 bcs nobefehl
rts
gr12005:
 movea.l a4,a0
 move.w #'MU',(a0)+            * MULS/MULU
 move.b #'L',(a0)+
 move (a3),d0
 and #$01c0,d0
 cmp #%111000000,d0
 bne.s gr12006
 move.b #'S',(a0)+              * MULS
bra.s gr12007
gr12006:
 cmp.b #%011000000,d0
 bne nobefehl
 move.b #'U',(a0)+              * MULU
gr12007:                        * Einsprung fr muls
 move.w #'.W',(a0)+             * Immer Wort
 bsr    check1adr               * Adressierungsart prfen
 bcs nobefehl
 moveq #1,d0                    * Wort
 bsr getadr1                    * Adressierungsart
 bcs nobefehl
 moveq #9,d3
bra dareg0                      * Ziel ist Datenregister

gruppe13:                       * ADDX
 move (a3),d0
 and #$f130,d0
 cmp #$d100,d0
 bne.s gr13001
 move.l #'ADDX',(a0)+
 bsr getgroess                  * Gre feststellen
 bcc gr8001
gr13000:
 movea.l a4,a0
gr13001:                        * ADDA
 move (a3),d0
 and #$f0c0,d0
 cmp #$d0c0,d0
 bne.s gr13003
 move.l #'ADDA',(a0)+
 moveq #1,d0                    * Wort
 btst #0,(a3)                   * Bit 0 bestimmt Gre
 beq.s *+4
 moveq #2,d0                    * Langwort
 bsr putgroess                  * Gre nur Wort oder Langwort
 bsr getadr1                    * Adressierungsart
 bcs nobefehl
 moveq #9,d3
bra adreg0                      * Ziel ist Adressregister
gr13002:
 movea.l a4,a0
gr13003:                        * ADD
 move.w #'AD',(a0)+
 move.b #'D',(a0)+
 bsr getgroess                  * Gre holen
 bcs nobefehl
 btst #0,(a3)                   * add <ea>,dn
 bne.s gr13004
 bsr getadr1                    * Adressierungsart
 bcs nobefehl
 moveq #9,d3
bra dareg0                      * Ziel ist Datenregister
gr13004:                        * add dn,<ea>
 moveq #9,d3
 bsr dareg1                     * Quelle ist Datenregister
 bsr    check2adr               * Adressierungsart prfen
 bcs nobefehl
 bsr getadr0                    * Adressierungsart
 bcs nobefehl
rts

gruppe14:
 move (a3),d0
 and #%111111000000,d0
 cmp.b #%11000000,d0
 bne.s gr14000
 btst #11,d0
 bne nobefehl                   * asd/lsd/rod/roxd <ea>
 lsr #7,d0
 and #$c,d0
 lea gr14tab0(pc),a1
 adda d0,a1
 move.w (a1)+,(a0)+             * Rotationsbefehl
 move.b (a1)+,(a0)+
 bne.s *+4
 subq.l #1,a0
 moveq #'L',d1                  * Links
 btst #0,(a3)                   * Bit 0 bestimmt Richtung
 bne.s *+4
 moveq #'R',d1                  * Oder Rechts
 move.b d1,(a0)+
 moveq #1,d0
 bsr putgroess                  * Gre ist Wort
 bsr    check2adr               * Adressierungsart prfen
 bcs nobefehl
 bsr getadr1                    * Adressierungsart
 bcs nobefehl
rts
gr14000:                        * asd/lsd/rod/roxd #konst/dx,dy
 move (a3),d0
 lsr #1,d0
 and #$c,d0
 lea gr14tab0(pc,d0),a1
 move.w (a1)+,(a0)+
 move.b (a1)+,(a0)+             * Befehl feststellen
 bne.s *+4
 subq.l #1,a0
 moveq #'L',d1
 btst #0,(a3)
 bne.s *+4
 moveq #'R',d1                  * Richtung der Schiebeoperation
 move.b d1,(a0)+
 bsr getgroess                  * Gre feststellen
 bcs nobefehl
 move (a3),d0
 btst #5,d0
 bne.s gr14001
 rol #7,d0                      * #konst,dy
 and #$7,d0
 bne.s *+4
 moveq #8,d0
 bsr konstb1                    * Konstante
bra.s gr14002
gr14001:                        * Dx,Dy
 moveq #9,d3
 bsr dareg1                     * Datenregister
gr14002:
 moveq #0,d3
bra dareg0                      * Ziel ist Datenregister

gr14tab0:                       * Tabelle der Schiebebefehle
 dc.b 'AS',0,0
 dc.b 'LS',0,0
 dc.b 'ROX',0
 dc.b 'RO',0,0

getatab1:                       * Tabelle Adressierungsarten
 dc.w geta1-getatab1            * Datenregister direkt
 dc.w geta2-getatab1            * Adressregister direkt
 dc.w geta3-getatab1            * Adressregister indirekt
 dc.w geta4-getatab1            * Adressregister indirekt mit Postinkrement
 dc.w geta5-getatab1            * Adressregister indirekt mit Predekrement
 dc.w geta6-getatab1            * Adressregister indirekt mit Adressdistanz
 dc.w geta7-getatab1            * Adressregister indirekt mit Index
 dc.w geta8-getatab1            * Verteilung auf andere Adressierungsarten

getsadr0:                       * Adressierungsart auswerten
 move.b #',',(a0)+              * Abstand Befehl-Adresse = 4
bra.s getsadr2
getsadr1:
 move.b #' ',(a0)+
getsadr2:
 move (a3),d3
 lea 4(a3),a2
bra.s getadr3

getadr0:                        * d0.w = Gre
 move.b #',',(a0)+              * a3 zeigt auf Opcode
bra.s getadr2                   * Carry bei Fehler
getadr1:
 move.b #' ',(a0)+
getadr2:
 lea 2(a3),a2                   * Normalerweise befinden sich die Adressen
                                * direkt hinter dem Opcode
 move (a3),d3                   * d3 Mode
getadr3:                        * Einsprung move-Befehl
 lsr #2,d3
 and #$e,d3                     * Adressierungsart steht hier
 move getatab1(pc,d3.w),d3
 jmp getatab1(pc,d3.w)

geta1:                          * Datenregister direkt
 moveq #0,d3
 bsr dareg2
 moveq #0,d0
bra carres
geta2:                          * Adressregister direkt
 tst.b d0
 beq carset                     * Kein Byte-Zugriff auf Adressregister
 moveq #0,d3
 bsr adreg2
 moveq #0,d0
bra carres
geta3:                          * ARI
 move.b #'(',(a0)+
 moveq #0,d3
 bsr adreg2                     * (an)
 move.b #')',(a0)+
 moveq #0,d0
bra carres
geta4:                          * ARI mit Postinkrement
 bsr.s geta3
 move.b #'+',(a0)+              * (an)+
bra carres
geta5:                          * ARI mit Predekrement
 move.b #'-',(a0)+              * -(an)
bra.s geta3
geta6:                          * ARI mit Adressdistanz
 move (a2),d0
 bsr put4x
 bsr.s geta3
 moveq #2,d0                    * d(an)
bra carres
geta7:                          * ARI mit Adressdistanz und Index
 move (a2),d0
 btst #8,d0
 bne carset
 bsr put2x                      * Adressdistanz
 move.b #'(',(a0)+
 moveq #0,d3
 bsr adreg2                     * Adressregister
geta700:                        * Einsprung PC relativ mit Adressdist. und Index
 exg.l a2,a3
 moveq #12,d3
 moveq #15,d4
 bsr reg0                       * Register
 exg.l a3,a2
 move.b #'.',(a0)+
 moveq #'W',d3                  * Wort
 move (a2),d2
 btst #11,d2                    * Bit 11 bestimmt Gre
 beq.s geta701
 moveq #'L',d3                  * Langwort
geta701:
 move.b d3,(a0)+
 rol.w #7,d2
 and #3,d2
 bne carset
 move.b #')',(a0)+
 moveq #2,d0
bra carres                      * d(an,rx) oder d(pc,rx)
geta8:
 move (a3),d3
 and #7,d3
 lsl #1,d3
 move getatab2(pc,d3.w),d3
 jmp getatab2(pc,d3.w)

getatab2:                       * Weitere Adressierungsarten
 dc.w geta81-getatab2           * Absolut kurz
 dc.w geta82-getatab2           * Absolut lang
 dc.w geta83-getatab2           * PC relativ mit Adressdistanz
 dc.w geta84-getatab2           * PC relativ mit Index und Adressdistanz
 dc.w konstante-getatab2        * Konstante
 dc.w carset-getatab2           * Fr Erweiterungen
 dc.w carset-getatab2           * Zur Zeit nicht genutzt
 dc.w carset-getatab2           *

geta81:                         * Absolut kurz
 move (a2),d2
 tst.b d0
 beq.s geta810
 btst.b #0,d2
 bne carset                     * Nicht auf ungerade Adressen bei Wort und Long
geta810:
 move d2,d0
 bsr put4x                     * Adressdistanz
 move.b #'.',(a0)+
 move.b #'W',(a0)+
 moveq #2,d0
bra carres
geta82:                         * Absolut lang
 move.l (a2),d2
 tst.b d0
 beq.s geta820
 btst.b #0,d2                   * Ungerade Adresse ?
 bne carset                     * Dann Fehler
geta820:
 move.l d2,d0
 bsr put8x                      * Adressdistanz
 move.b #'.',(a0)+
 move.b #'L',(a0)+
 moveq #4,d0
bra carres
geta83:                         * PC relativ mit Adressdistanz
 move (a2),d2
 tst.b d0
 beq.s geta830
 btst.b #0,d2                   * Ungerade Adressdistanz
 bne carset
geta830:
 ext.l d2
 move.l d2,d0
 add.l a2,d0                    * Zieladresse
 bsr put8x                      * Adressdistanz
 move.b #'(',(a0)+
 move.b #'P',(a0)+
 move.b #'C',(a0)+
 move.b #')',(a0)+              * d(PC)
 moveq #2,d0
bra carres
geta84:                         * PC relativ mit Adressdistanz und Index
 move (a2),d0
 btst #8,d0
 bne carset
 ext.w d0
 ext.l d0
 add.l a2,d0                    * Zieladresse
 bsr put8x                      * Adressdistanz
 move.b #'(',(a0)+
 move.b #'P',(a0)+
 move.b #'C',(a0)+
 moveq #2,d0
bra geta700

check1adr:                      * Adressierungsart prfen mit verschiedenen
 lea    eatab1(pc),a2           * Tabellen
bra.s   checkadr

check2adr:
 lea    eatab2(pc),a2           * Tabelle 2
bra.s   checkadr

check3adr:
 lea    eatab3(pc),a2           * Tabelle 3
bra.s   checkadr

check4adr:
 lea    eatab4(pc),a2           * Tabelle 4
bra.s   checkadr

check5adr:
 lea    eatab5(pc),a2           * Tabelle 5
bra.s   checkadr

check6adr:
 lea    eatab6(pc),a2           * Tabelle 6
bra.s   checkadr

check7adr:
 lea    eatab7(pc),a2           * Tabelle 7
bra.s   checkadr

check8adr:
 lea    eatab8(pc),a2           * Tabelle 8

checkadr:                       * a3 auf Opcode
 move (a3),d6                   * a2 Ziel fr Tabelle fr unerlaubten Opcode
chadr1:                         * Carry wenn falsch
 lsr #3,d6                      * Tabelle
 and #7,d6                      * dc.b Anzahl Mode-1
 move.b (a2)+,d7                * dc.b Unerlaubter Mode, unerlaubter Mode
 ext d7                         * dc.b Anzahl Reg-1
 bmi.s chadr3                   * dc.b Unerlaubtes Reg,unerlaubtes Reg
chadr2:
 cmp.b (a2)+,d6
 beq carset                     * Fehler
dbra d7,chadr2
chadr3:
 cmp.b #%111,d6                 * PC-relative Adressierungsarten
 bne carres
 move (a3),d6
 and #7,d6
 cmp #5,d6                      * Gar nicht erlaubt
 bpl carset
 move.b (a2)+,d7
 ext d7
 bmi carres
chadr4:
 cmp.b (a2)+,d6
 beq carset                     * Fehler
dbra d7,chadr4
bra carres

getgroess:                      * Gre ermitteln und ausgeben
 bsr.s getgr1                   * Gre holen
 bcs carset                     * Fehler
putgroess:
 move.b #'.',(a0)+
 move.b putgrtab(pc,d0.w),(a0)+ * Zeichen B,W,L
bra carres

getgr1:                         * Gre ermitteln
 move (a3),d0
 lsr #6,d0
 and #3,d0                      * Drei Bits bestimmen Gre
 cmp #3,d0
 beq carset                     * Fehler, 3 nicht erlaubt
bra carres

putgrtab:
 dc.b 'BWL'
 ds 0

put2x:
 move.b #'$',(a0)+
bra print2x

put4x:
 move.b #'$',(a0)+
bra print4x

put8x:
 move.b #'$',(a0)+
bra print8x

reg0:                           * d3=Bit Register/d4=Bit Da/Ad
 move.b #',',(a0)+              * a3 auf Adresse
bra.s reg2
reg1:
 move.b #' ',(a0)+
reg2:
 move (a3),d7
 btst d4,d7                     * Daten- oder Adressregister ?
 beq.s reg3
 move.b #'A',(a0)+              * Adressregister
bra.s dareg4
reg3:
 move.b #'D',(a0)+              * Datenregister
bra.s dareg4

dareg0:                         * a3 zeigt auf Opcode d0 ist Bitnummer
 move.b #',',(a0)+              * Datenregisterausgabe
bra.s dareg2
dareg1:
 move.b #' ',(a0)+
dareg2:
 move.b #'D',(a0)+
dareg3:                         * Einsprung Adressregister
 move (a3),d7
dareg4:
 lsr d3,d7
 and #7,d7                      * Nur 3 Bits bestimmen Nummer
 add.b #'0',d7                  * In ASCII wandeln
 move.b d7,(a0)+
rts

adreg0:                         * Adressregisterausgabe
 move.b #',',(a0)+
bra.s adreg2
adreg1:
 move.b #' ',(a0)+
adreg2:
 move.b #'A',(a0)+
bra.s dareg3

nobefehl:                       * Gibt dc.w aus / Wenn kein Befehl
 movea.l a4,a0
 move.l #'!!! ',(a0)+           * ACHTUNG !!!
 move (a3),d0
 move.l #'DC.W',(a0)+
 move.w #' $',(a0)+
bra print4x                     * Hexadezimalausgabe

konstante:                      * In d0 Gre/in a2 Wert
 tst d0                         * d0 ist Ergebnis Lnge in Bytes
 bne.s konst1
 move.w (a2),d0
 bsr.s konstb2                  * Byte
 bcs carset
 moveq #2,d0                    * Lnge
bra carres
konst1:
 cmp #1,d0
 bne.s konst2
 move (a2),d0
 bsr.s konstw2                  * Wort
 moveq #2,d0                    * Lnge
bra carres
konst2:
 cmp #2,d0
 bne carset                     * Fehler
 move.l (a2),d0
 bsr.s konstlw2                 * Langwort
 moveq #4,d0                    * Lnge
bra carres

konstb1:                        * In d0.b Konstante
 move.b #' ',(a0)+              * Wird zerstrt
konstb2:
 move.b #'#',(a0)+
 move d0,d7
 and #$ff00,d7
 bne carset                     * Kein Byte -> Fehler
 move.b #'$',(a0)+
 bsr print2x
bra carres

konstlw0:
 move.b #',',(a0)+
bra.s konstlw2
konstlw1:                       * In d0.l Konstante
 move.b #' ',(a0)+
konstlw2:
 move.b #'#',(a0)+
 move.b #'$',(a0)+
bra print8x

konstw0:
 move.b #',',(a0)+
bra.s konstw2
konstw1:                        * In d0.w Konstante
 move.b #' ',(a0)+
konstw2:
 move.b #'#',(a0)+
 move.b #'$',(a0)+
bra print4x

eatab1:                         * Tabellen der nicht erlaubten Adresierungsarten
 dc.b 1-1
 dc.b %001                      * Dn
 dc.b 0-1

eatab2:
 dc.b 2-1
 dc.b %000                      * Dn
 dc.b %001                      * An
 dc.b 3-1
 dc.b %010                      * d(PC)
 dc.b %011                      * d(PC,Rx)
 dc.b %100                      * #

eatab3:
 dc.b 4-1
 dc.b %000                      * Dn
 dc.b %001                      * An
 dc.b %011                      * (An)+
 dc.b %100                      * -(An)
 dc.b 1-1
 dc.b %100                      * #

eatab4:
 dc.b 1-1
 dc.b %001                      * An
 dc.b 3-1
 dc.b %010                      * d(PC)
 dc.b %011                      * d(PC,Rx)
 dc.b %100                      * #

eatab5:
 dc.b 0-1
 dc.b 3-1
 dc.b %010                      * D(PC)
 dc.b %011                      * d(PC,Rx)
 dc.b %100                      * #

eatab6:
 dc.b 1-1
 dc.b %001                      * An
 dc.b 1-1
 dc.b %100                      * #

eatab7:
 dc.b 3-1
 dc.b %000                      * Dn
 dc.b %001                      * An
 dc.b %100                      * -(An)
 dc.b 1-1
 dc.b %100                      * #

eatab8:
 dc.b 3-1
 dc.b %000                      * Dn
 dc.b %001                      * An
 dc.b %011                      * (An)+
 dc.b 3-1
 dc.b %010                      * d(PC)
 dc.b %011                      * d(PC,Rx)
 dc.b %100                      * #

ds 0
                                                                                                                                                                                                                                                                                                                                                                                                           * Bereichsfehler
 move.l d0,d6
 bsr kommack                    * Komma mu folgen
 bsr expr1                      * Wert holen
 move.l d0,d1
 tst wordbyte(a5)
 bne.s coddf1
coddf0:
 bsr co2test                    * Extraabfrage, da eventuell lngere Schleife
 bcs abbruch                    * Abbruch mit Ctrl-C
 move.l d1,d0
 bsr rangebck                   * Byte, deshalb Bereich testen
 bsr putbyte                    * Byte ausgeben
 subq.l #1,d6
bne.s coddf0                    *